﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.JSON.LitJson;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        private Dictionary<string, BaseAPIMethod> _apiMethods = new Dictionary<string, BaseAPIMethod>();
        public ELearning(Gemini.Core.WebApplication.Base.APIComponentParam APIComponentParam)
            : base(APIComponentParam) 
        { }

       
        public override string Name
        {
            get { return "ersystem"; }
        }

        public override List<KeyValuePair<string, string>> GetAdditionalResponseHeaders()
        {
            List<KeyValuePair<string, string>> _result = new List<KeyValuePair<string, string>>();
            _result.Add(new KeyValuePair<string, string>("Access-Control-Allow-Origin", "*"));
            return _result;
        }

        private PI.FM.N001.Account.BL.Account _blAccount = null;
        
        private BL.ZSBELearning _blELearning = null;

        public BL.ZSBELearning BLELearning
        {
            get
            {
                if (_blELearning == null)
                {
                    _blELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blELearning;
            }
        }

        public PI.FM.N001.Account.BL.Account BLAccount
        {
            get
            {
                if (_blAccount == null)
                {
                    _blAccount = new PI.FM.N001.Account.BL.Account(Environment);
                }
                return _blAccount;
            }
        }


        public override long ClientID
        {
            get { return BLELearning.ClientID; }
        }

        public override bool IsXSLRender { get { return false; } }

        public override Gemini.Core.WebApplication.Interface.IRenderResult Render(System.Xml.Xsl.XslCompiledTransform XSLWebPageComponent)
        {
            // apiname=ersystem&method=userslogin&api_key=123&.......
            if (MethodName.Equals(this.Name))
            {
                string _method = APIRequestParams["method"];
                if (!string.IsNullOrEmpty(_method))
                {
                    if (CheckAPIKey())
                    {
                        BaseAPIMethod _apiMethod = null;
                        _method = _method.Trim().ToLower();
                        switch (_method)
                        {
                            case "userslogin":
                                _apiMethod = new MethodUsersLogin(this);
                                break;
                            case "userslogout":
                                _apiMethod = new MethodUsersLogout(this);
                                break;
                            case "schoolsindex":
                                _apiMethod = new MethodSchoolsIndex(this);
                                break;
                            case "schoolsview":
                                _apiMethod = new MethodSchoolsView(this);
                                break;
                            case "usersindex":
                                _apiMethod = new MethodUsersIndex(this);
                                break;
                            case "classindex":
                                _apiMethod = new MethodClassIndex(this);
                                break;
                            case "usersview":
                                _apiMethod = new MethodUsersView(this);
                                break;
                            case "competencesindex":
                                _apiMethod = new MethodCompetencesIndex(this);
                                break;
                            case "competencesstart":
                                _apiMethod = new MethodCompetencesStart(this);
                                break;
                            case "competencesnext":
                                _apiMethod = new MethodCompetencesNext(this);
                                break;
                            case "competencesprev":
                                _apiMethod = new MethodCompetencesPrev(this);
                                break;
                            case "competencessave":
                                _apiMethod = new MethodCompetencesSave(this);
                                break;
                            case "statsview":
                                _apiMethod = new MethodStatsView(this);
                                break;
                            case "certificatesindex":
                                _apiMethod = new MethodCertificatesIndex(this);
                                break;
                            case "competencesmenu":
                                _apiMethod = new MethodCompetencesMenu(this);
                                break;
                            case "rankingview":
                                _apiMethod = new MethodRankingView(this);
                                break;
                            case "statscompetencesview":
                                _apiMethod = new MethodStatsCompetencesView(this);
                                break;
                            case "usersprofile":
                                _apiMethod = new MethodUserProfile(this);
                                break;
                            case "userspasswordchange":
                                _apiMethod = new MethodUserPasswordChange(this);
                                break;
                            case "usersprofilesave":
                                _apiMethod = new MethodUserProfileSave(this);
                                break;
                        }

                        if (_apiMethod != null)
                        {
                            return new Gemini.Core.WebApplication.Base.RenderResultBase(_apiMethod.GetResponseString()) { StatusCode = (System.Net.HttpStatusCode)_apiMethod.StatusCode };
                        }
                        else
                        {
                            return new Gemini.Core.WebApplication.Base.RenderResultBase(string.Empty) { StatusCode = System.Net.HttpStatusCode.NotImplemented };
                        }
                    }
                    else
                    {
                        return new Gemini.Core.WebApplication.Base.RenderResultBase(string.Empty) { StatusCode = System.Net.HttpStatusCode.NotAcceptable };
                    }
                }
            }

            return new Gemini.Core.WebApplication.Base.RenderResultBase(string.Empty) { StatusCode = System.Net.HttpStatusCode.BadRequest };
        }

        private void RegisterMethod(BaseAPIMethod BaseAPIMethod)
        {
            _apiMethods.Add(BaseAPIMethod.Name, BaseAPIMethod);
        }

        private bool CheckAPIKey()
        {
            string _api_key = APIRequestParams["api_key"];
            return !string.IsNullOrEmpty(_api_key);
        }
    }
}